﻿//////////////////////////////////////////////
// ScriptWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkScriptsWrap
{
	class DLL_ASTRAEUS_EXPORT ScriptWrapper final
	{
		public :

			// Env
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Constructeur, destructeur
			static void* constructor (const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Getters
			static nkScripts::OutputValue getTargetInterpreter (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getName (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getSources (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getLastCompilationResult (const nkScripts::DataStack& stack) ;
			// Setters
			static nkScripts::OutputValue setTargetInterpreter (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setName (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue setSources (const nkScripts::DataStack& stack) ;
			// Loading
			static nkScripts::OutputValue load (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue unload (const nkScripts::DataStack& stack) ;
			// Global
			static nkScripts::OutputValue call (const nkScripts::DataStack& stack) ;
	} ;
}